package pack;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import java.awt.*;
import java.io.*;
import java.util.concurrent.TimeUnit;

public class Excelreadwrite {

    private static WebDriver driver;
    private static String baseUrl;
    private static int n = 0;

    @BeforeTest
    public void setUp() {
        driver = new ChromeDriver();
        baseUrl = "https://www.google.com";
        driver.manage().timeouts().implicitlyWait(30, TimeUnit.SECONDS);
    }

    @Test(dataProvider = "DP")
    public static String login(String keyword, String expectedtitle)
            throws Exception {
        driver.get(baseUrl + "/");

        driver.findElement(By.name("q")).sendKeys(keyword);
        driver.findElement(By.name("q")).sendKeys(Keys.ENTER);
        Thread.sleep(2000);
        String actualtitle = driver.getTitle();
        System.out.println(actualtitle);
        driver.findElement(By.name("q")).clear();

        int LastRow = ++n;
        if (expectedtitle.equals(actualtitle)) {
            System.out.println("SUKCES");
            String status = "SUKCES";
            excelwrite(status, LastRow);
        } else {
            System.out.println("PORAŻKA");
            String status = "PORAŻKA";
            excelwrite(status, LastRow);
        }
        return expectedtitle;
    }

    @AfterTest
    public void tearDown() throws Exception {
        driver.quit();
    }

    public static void main(String[] args) throws Exception {
        excelRead();
    }

    @DataProvider(name = "DP")
    public static String[][] excelRead() throws Exception {
        File excel = new File("/Users/prashanth_sams/Desktop/data.xls");
        FileInputStream fis = new FileInputStream(excel);
        HSSFWorkbook wb = new HSSFWorkbook(fis);
        HSSFSheet ws = wb.getSheet("Arkusz1");
        int rowNum = ws.getLastRowNum() + 1;
        int colNum = ws.getRow(0).getLastCellNum();
        String[][] data = new String[(rowNum - 1)][colNum];
        int k = 0;
        for (int i = 1; i < rowNum; i++) {
            HSSFRow row = ws.getRow(i);
            for (int j = 0; j < colNum; j++) {
                HSSFCell cell = row.getCell(j);
                String value = cellToString(cell);
                data[k][j] = value;
            }
            k++;
        }
        return data;
    }

    public static void excelwrite(String status, int LastRow) throws Exception 	{
        try {
            FileInputStream file = new FileInputStream(new File(
                    "/Users/prashanth_sams/Desktop/data.xls"));

            HSSFWorkbook workbook = new HSSFWorkbook(file);
            HSSFSheet sheet = workbook.getSheetAt(0);

            Row row = sheet.getRow(LastRow);

            Cell cell2 = row.createCell(2); // zmień numer komórki w zależności od wielkości kolumny
            cell2.setCellValue(status);
            // System.out.println(status);
            file.close();
            FileOutputStream outFile = new FileOutputStream(new File(
                    "/Users/prashanth_sams/Desktop/data.xls"));
            workbook.write(outFile);

        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (HeadlessException e) {
            e.printStackTrace();
        }
    }

    public static String cellToString(HSSFCell cell) {
        int type;
        Object result;
        type = cell.getCellType();
        switch (type) {
            case 0:
                result = cell.getNumericCellValue();
                break;
            case 1:
                result = cell.getStringCellValue();
                break;
            default:
                throw new RuntimeException("Ten rodzaj komórki nie jest wspierany");
        }
        return result.toString();
    }

}